import Content from "./Content";
import { constructMetadata } from "@/components/utils/seo";

const seoData = {
  ar: {
    title: "من نحن ..",
    description: "نحن فريق متخصص يجمع بين الخبرة الطويلة والرؤية الحديثة لنقدّم حلولًا مبتكرة ومتكاملة."
  },
  en: {
    title: "Who We Are",
    description: "We are a specialized team combining long experience with modern vision..."
  }
};

type Props = {
  params: { locale: string }
}

export async function generateMetadata({ params }: Props) {
  const locale = params.locale === 'en' ? 'en' : 'ar';
  const data = seoData[locale];

  return constructMetadata({
    title: data.title,
    description: data.description,
    canonicalUrlRelative: `/${locale}/who-we-are`,
  });
}

export default function Page() {
  return (
    <Content />
  );
}